#!/usr/bin/perl -w

########################
#                      #
# Modules	       #
#                      #
########################

use strict;
use CGI;
use CGI::Carp qw ( fatalsToBrowser );
use DBI;

use lib 'lib';
use Crosslinker::HTML;
use Crosslinker::Constants;
use Crosslinker::Data;
use Crosslinker::Config;

my $path = installed;

########################
#                      #
# Summary Gen          #
#                      #
########################

print_page_top_bootstrap("Score");
my $version = version();
print '<div class="row">
<div class="span8 offset2">
   <div class="page-header">
  <h1>Hekate <small>Score</small></h1>
</div></div></div>';
print <<ENDHTML;
<div class="row">
<div class="span8 offset2">

<form method="POST" enctype="multipart/form-data" action="singlescan_search.pl">
<fieldset>
<legend>Settings</legend><br/>
<div class="row">
<div class="span4"> 
   <label>Digest</label>
    <select name="enzyme"> 
ENDHTML

my $dbh = connect_conf_db;
my $enzymes = get_conf($dbh, 'enzyme');

while ((my $enzyme = $enzymes->fetchrow_hashref)) {
    print "<option value='" . $enzyme->{'rowid'} . "' ";
    if ($enzyme->{'name'} eq 'Trypsin') { print "selected='true'" }
    print ">" . $enzyme->{'name'} . " </option>";
}
$enzymes->finish();

print <<ENDHTML;
     </select> 
   
    <label>MS2 accurracy (Da)</label>
    <input type="text" name="ms2_da" size="2" maxlength="3" value="0.8"/> 
    <label>Doublet Spacing Tollerance</label>
    <div class="input-append"><input type="text" name="ms_ppm" size="4" maxlength="4" value="50"/><span class="add-on">ppm</span></div>
    <label>Threshold</label>
    <input type="text" name="threshold" size="3" maxlength="3" value="2"/> 
    <span class="help-block">as a % of the maximum intensity</span>
</div>
<div class="span4">
    <label>Maximum Missed Cleavages</label>
    <input type="text" name="missed_cleavages" size="2" maxlength="3" value="3"/>
    <label>MS1 accurracy</label>
    <div class="input-append"><input type="text" name="ms1_ppm" size="2" maxlength="2" value="2"/><span class="add-on">ppm</span></div>
    <label>Max scan seperation</label>
    <input type="text" name="scan_width" size="4" maxlength="4" value="60"/><br/>
    <label class="checkbox inline" ><input type="checkbox" name="decoy" value="true">Decoy&nbsp;Search</label><br/>  
    <label class="checkbox inline" ><input type="checkbox" name="charge_match"  checked="checked" value="true">Require&nbsp;Charge&nbsp;Match</label><br/>
    <label class="checkbox inline" ><input type="checkbox" name="allow_xlink_at_cut_site" value="true" >Allow&nbsp;cross&#8209;linking&nbsp;at&nbsp;cut&nbsp;site</label><br/>
    <label class="checkbox inline" ><input type="checkbox" name="detailed_scoring"  value="true">Detailed&nbsp;scoring</label><br/>
     <span class="help-block">these are found in the csv output only</span>
</div>
</div>

<div class="row">
<div class="span4">
  <label class="checkbox inline" ><input type="checkbox" name="intensity_match" value="true" >Intensity&nbsp;Match&nbsp;(MS1)</label>
</div>
<div class="span4">
    <label>Maximum intensity ratio</label><input type="text" name="ms1_intensity_ratio" size="4" maxlength="4" value="0.8"/>
</div>
</div>

<legend>Modifications</legend>
<div class="row">
<div class="span4">
    <label>Dynamic Modifications</label>
    <select style="width: 20em;" multiple="multiple" size="5"  name="dynamic_mod"> 
ENDHTML

my $mods = get_conf($dbh, 'dynamic_mod');
while ((my $mod = $mods->fetchrow_hashref)) {
    my $selected = '';
    if ($mod->{'setting3'} == 1) { $selected = 'selected="true"' }
    print "<option $selected value='" . $mod->{'rowid'} . "'>" . $mod->{'name'} . "</option>";
}
print <<ENDHTML;
 </select> 
</div>
<div class="span4">
    <label>Fixed Modifications</label>
    <select style="width: 20em;" multiple="multiple" size="5"  name="fixed_mod"> 
ENDHTML

$mods = get_conf($dbh, 'fixed_mod');
while ((my $mod = $mods->fetchrow_hashref)) {
    my $selected = '';
    if ($mod->{'setting3'} == 1) { $selected = 'selected="true"' }
    print "<option $selected value='" . $mod->{'rowid'} . "'>" . $mod->{'name'} . "</option>";
}
$mods->finish();
print <<ENDHTML;
   </select> 
</div>
</div>
<legend>Crosslinking Reagent</legend>
<div class="row">
<div class="span8">
  <label>Crosslinking Reagent<label>
  <select name='crosslinker'> 
ENDHTML

my $crosslinkers = get_conf($dbh, 'crosslinker');
while ((my $crosslinker = $crosslinkers->fetchrow_hashref)) {
    print "<option value='" . $crosslinker->{'rowid'} . "'>" . $crosslinker->{'name'} . "</option>";
}
$crosslinkers->finish();
print "<option value='-1' selected='true'>Custom (enter below)</option></select>";
print <<ENDHTML;
</div>
</div>
<div class="row">
<div class="span4">
  <label>Linker mass</label>
  <div class="input-append"><input type="text" name="xlinker_mass" size="10" maxlength="10" value="96.0211296"/><span class="add-on">Da</span></div><br/> 
  <label>Isotope type</label> 
  <select name="isotope"><option>deuterium</option><option>carbon-13</option><option>none</option></select> 
  <label>Number of labelled atoms in isotopic form</label>
  <input type="text" name="seperation" size="2" maxlength="5" value="4"/> 
</div>
<div class="span4">
 <label>Monolink mass</label>
 <div class="input-append"><input type="text" name="mono_mass_diff" size="10" maxlength="21" value="114.0316942"/><span class="add-on">Da</span></div>
 <label>Reactive amino acid</label>
 <input type="text" name="reactive_site" size="10" maxlength="10" value="K"/>
</div>
</div>

<Legend>Fragment Ions</legend>
<div class="row">
<div class="span3"> 
  <h4>Label ions on figures</h4> 
</div>
<div class="span3 ">
 <h4>Use ions to calculate score</h4>
</div>
</div>
<div class="row">
<div class="span2 offset1">
    <label class="span2 checkbox" ><input type="checkbox" name="aions" checked="checked"  value="1"/>A-ions</label>
    <label class="span2 checkbox" ><input type="checkbox" name="bions" checked="checked"  value="1"/> B-ions</label>
    <label class="span2 checkbox" ><input type="checkbox" name="yions" checked="checked"  value="1"/> Y-ions</label>
    <label class="span2 checkbox" ><input type="checkbox" name="waterloss" checked="checked" value="1">Water Loss</label>
    <label class="span2 checkbox" ><input type="checkbox" name="ammonialoss"checked="checked" value="1"> Ammonia Loss</label>
</div>
   
<div class="span2 offset1">
    <label class="span2 checkbox" ><input type="checkbox" name="aions-score" value="1"/> A-ions</label>
    <label class="span2 checkbox" ><input type="checkbox" name="bions-score" checked="checked"  value="1"/> B-ions</label>
    <label class="span2 checkbox" ><input type="checkbox" name="yions-score" checked="checked"  value="1"/> Y-ions</label>
    <label class="span2 checkbox" ><input type="checkbox" name="waterloss-score"  value="1">Water Loss</label>
    <label class="span2 checkbox" ><input type="checkbox" name="ammonialoss-score" value="1"> Ammonia Loss</label>
</div>
</div>
<legend>Protein Sequences</legend>
<div class="row">
<div class="span8">
<label>Sequence</label>
<select name="sequence"> 
ENDHTML

my $sequences = get_conf($dbh, 'sequence');
while ((my $sequence = $sequences->fetchrow_hashref)) {
    print "<option value='" . $sequence->{'rowid'} . "'>" . $sequence->{'name'} . "</option>";
}
$sequences->finish();
print "<option value='-1' selected='true'>Custom (enter below in FASTA format)</option>";
print <<ENDHTML;
</select> 
</div>
</div>
<div class="row">
<div class="span8">
<textarea name="user_protein_sequence" rows="12" class="span8">>PolIII
MGSSHHHHHHSSGLEVLFQGPHMSEPRFVHLRVHSDYSMIDGLAKTAPLVKKAAALGMPALAITDFTNLCGLVKFYGAGHGAGIKPIVGADFNVQCDLLGDELTHLTVLAANNTGYQNLTLLISKAYQRGYGAAGPIIDRDWLIELNEGLILLSGGRMGDVGRSLLRGNSALVDECVAFYEEHFPDRYFLELIRTGRPDEESYLHAAVELAEARGLPVVATNDVRFIDSSDFDAHEIRVAIHDGFTLDDPKRPRNYSPQQYMRSEEEMCELFADIPEALANTVEIAKRCNVTVRLGEYFLPQFPTGDMSTEDYLVKRAKEGLEERLAFLFPDEEERLKRRPEYDERLETELQVINQMGFPGYFLIVMEFIQWSKDNGVPVGPGRGSGAGSLVAYALKITDLDPLEFDLLFERFLNPERVSMPDFDVDFCMEKRDQVIEHVADMYGRDAVSQIITFGTMAAKAVIRDVGRVLGHPYGFVDRISKLIPPDPGMTLAKAFEAEPQLPEIYEADEEVKALIDMARKLEGVTRNAGKHAGGVVIAPTKITDFAPLYCDEEGKHPVTQFDKSDVEYAGLVKFDFLGLRTLTIINWALEMINKRRAKNGEPPLDIAAIPLDDKKSFDMLQRSETTAVFQLESRGMKDLIKRLQPDCFEDMIALVALFRPGPLQSGMVDNFIDRKHGREEISYPDVQWQHESLKPVLEPTYGIILYQEQVMQIAQVLSGYTLGGADMLRRAMGKKKPEEMAKQRSVFAEGAEKNGINAELAMKIFDLVEKFAGYGFNKSHSAAYALVSYQTLWLKAHYPAEFMAAVMTADMDNTEKVVGLVDECWRMGLKILPPDINSGLYHFHVNDDGEIVYGIGAIKGVGEGPIEAIIEARNKGGYFRELFDLCARTDTKKLNRRVLEKLIMSGAFDRLGPHRAALMNSLGDALKAADQHAKAEAIGQADMFGVLAEEPEQIEQSYASCQPWPEQVVLDGERETLGLYLTGHPINQYLKEIERYVGGVRLKDMHPTERGKVITAAGLVVAARVMVTKRGNRIGICTLDDRSGRLEVMLFTDALDKYQQLLEKDRILIVSGQVSFDDFSGGLKMTAREVMDIDEAREKYARGLAISLTDRQIDDQLLNRLRQSLEPHRSGTIPVHLYYQRADARARLRFGATWRVSPSDRLLNDLRGLIGSEQVELEFD 
    </textarea> 
</div>
</div>
<legend>Data</legend>
<div class="row">
<div class="span8">
<label>Precursor M/Z</label>
 <div class="input-append"><input type="text" name="precursor_mass" size="10" maxlength="10" value="906.51953"/><span class="add-on">Th</span></div>
<label>Charge</label>
 <div class="input-append"><input type="text" name="precursor_charge" size="2" maxlength="1" value="2"/> <span class="add-on">+</span></div>
<label>Spectra data</label>
<textarea  class="span4" name="light_scan" rows="12" cols="72">
262.218 27.9153
264.022 10.4977
282.064 5.20182
294.402 3.05985
296.147 4.77704
298.299 2.3788
310.110 3.923
314.496 3.3509
318.051 4.26692
319.192 8.9861
322.133 12.874
337.283 19.0437
338.706 3.0364
346.177 3.69469
349.151 93.6319
353.315 17.1432
356.156 54.763
358.980 11.6462
365.246 47.4259
371.008 14.377
372.212 17.4285
373.259 11.2037
374.509 4.69961
383.386 42.0015
390.048 14.9503
392.135 7.23436
393.315 6.59018
399.666 8.46103
406.455 13.3028
409.702 5.07317
410.775 16.5979
425.339 6.01108
427.316 8.67143
438.567 10.5523
442.269 3.04248
449.137 3.76306
454.273 32.2104
459.635 22.1879
460.410 32.6324
464.281 34.544
466.460 11.826
469.533 2.60556
470.235 22.1346
478.283 107.897
480.063 7.24006
482.065 38.3322
487.112 104.867
488.307 13.1374
498.237 6.14082
499.553 7.01273
501.468 14.1312
503.440 14.1866
508.888 19.5723
512.541 7.00453
524.506 8.79943
526.285 7.59546
530.293 16.9802
532.441 13.8288
534.389 15.4832
535.648 4.65608
539.664 4.99902
543.341 5.52393
552.040 4.77206
554.893 11.1465
556.246 6.52048
558.268 107.008
568.026 8.94129
570.117 23.3313
574.053 2.81241
576.136 31.4934
580.597 12.5001
582.505 8.10972
584.206 17.0979
584.836 9.88443
587.193 2.17287
588.189 5.31779
589.470 6.22512
592.985 96.9311
595.363 11.614
596.490 15.8617
597.456 4.77406
598.370 13.7827
601.985 55.8408
603.439 5.30206
607.191 7.7114
609.344 15.0653
611.495 6.78519
612.423 2.82586
615.312 23.0855
617.330 16.467
618.607 4.42451
626.553 3.47273
627.446 9.98809
630.393 8.08476
632.555 6.53846
633.482 19.9481
634.107 6.39347
636.329 18.7804
638.283 48.5643
639.078 13.2091
641.317 19.6712
642.648 37.7758
646.416 16.493
647.657 11.7865
649.551 8.34892
655.211 12.2242
657.004 101.793
657.979 9.60811
658.637 10.6435
659.477 12.0129
662.488 37.7924
665.850 141.594
668.057 7.67013
669.680 25.117
671.340 15.2185
674.587 27.7714
675.550 11.3275
680.767 10.0741
683.614 18.5473
684.725 9.94496
686.340 90.2662
687.573 11.7741
688.389 2.84754
690.590 7.60764
691.395 3.32054
692.166 8.43572
694.693 24.3256
695.762 21.9736
703.795 174.111
704.520 1097.06
706.517 56.8393
707.188 9.08379
708.249 13.5015
709.707 24.8599
711.903 59.7815
713.166 12.5239
715.568 108.655
720.043 4.63329
720.709 14.6222
721.673 3.69525
723.343 16.0686
730.226 44.9278
731.395 60.7227
732.523 112.119
735.041 21.986
738.492 95.2107
739.107 32.5364
740.379 33.2905
744.003 22.3205
747.626 769.975
749.575 153.442
750.736 4.84994
751.388 8.17436
752.067 6.61227
754.218 7.33479
755.082 14.6273
756.495 514.77
757.130 9.19719
758.542 14.0952
760.505 54.0529
761.208 4.84669
762.718 8.75903
763.698 23.7422
765.524 13.5424
767.070 27.725
768.349 23.9127
769.350 48.5096
771.462 17.9618
772.256 50.6643
773.012 2.21929
773.763 23.7743
774.520 24.8287
775.422 3.24919
777.505 13.0422
778.544 15.2816
780.571 45.7065
781.698 5.07848
785.193 12.2547
789.407 35.2683
790.557 51.3466
791.941 8.17771
793.003 24.7188
794.725 8.68325
795.630 10.6962
796.711 9.17872
797.903 163.385
800.216 73.5116
801.325 22.4732
802.759 52.9539
806.383 4.55722
807.355 93.5733
808.622 35.4565
811.574 752.657
812.250 44.264
814.191 48.4671
814.850 3.06789
815.744 26.7952
817.559 11.6375
820.547 1709.79
821.188 28.6423
824.656 266.509
825.427 2.12623
827.120 15.7172
827.746 11.7475
829.414 7.58682
830.407 9.62948
831.064 2.16336
832.361 2.82195
833.506 903.224
834.107 19.2987
835.798 9.66732
836.712 67.4637
838.320 40.53
839.404 7.69306
840.302 35.7358
842.616 1643.4
843.239 15.386
844.261 18.2562
844.990 5.30254
846.497 95.7368
853.076 153.605
853.768 39.6886
856.569 145.612
857.340 44.8517
858.264 33.0486
859.339 5.9596
861.489 47.3964
863.797 3.53888
866.413 25.9325
867.287 23.0311
867.987 12.8849
869.455 66.6326
870.702 12.0054
871.540 2.38463
873.742 18.7632
874.647 8.53741
875.700 73.2665
876.527 10.2736
879.041 43.9429
879.740 12.6723
882.734 15.9309
883.419 11.9875
884.603 95.113
885.490 26.3763
887.449 114.404
888.577 464.731
889.397 132.589
891.261 53.8908
892.767 6.08387
893.430 6.4129
896.930 103.081
897.644 1367.64
899.628 11.7815
902.211 9.18179
918.702 4.33941
919.604 12.0383
921.743 18.7697
922.729 5.58706
927.701 20.257
933.379 4.843
935.233 37.4269
936.382 71.2392
937.098 4.94774
942.790 2.81914
945.203 40.788
945.928 1.61067
952.593 8.97325
953.755 2.51128
960.490 42.8997
962.601 32.5497
964.956 3.47065
965.853 6.88743
972.491 5.43196
978.434 37.6879
980.773 77.0925
982.700 15.9852
986.061 17.6236
990.587 2.40011
993.794 11.9834
1006.850 9.71117
1007.988 7.16954
1008.938 16.6751
1011.438 8.55644
1012.529 2.82242
1016.133 17.8661
1022.945 16.2195
1023.860 15.2707
1029.385 20.411
1030.095 11.4566
1031.714 23.8215
1033.785 9.859
1035.740 6.08431
1037.660 22.0076
1038.497 16.4814
1041.998 21.4625
1046.611 12.8221
1050.896 10.714
1055.432 20.3294
1056.533 50.7282
1063.126 7.90225
1064.833 26.7331
1066.142 9.56775
1067.480 7.14542
1073.785 733.319
1074.930 14.9103
1078.163 2.38218
1089.665 5.43403
1090.789 178.994
1091.854 73.0079
1104.551 21.9886
1107.184 9.44895
1108.683 228.422
1109.292 5.9551
1111.529 17.5047
1113.658 10.583
1118.552 2.1628
1119.641 7.88502
1124.349 19.4645
1128.481 12.4196
1136.768 12.4952
1139.000 6.4748
1139.672 26.5448
1144.191 21.8441
1145.769 3.33535
1147.350 10.7403
1162.819 10.1707
1163.747 12.1408
1166.670 41.5389
1172.036 13.925
1179.711 6.81767
1184.711 226.004
1186.746 2.17385
1188.866 8.52319
1189.714 3.89993
1193.696 24.9672
1195.107 2.39138
1202.630 38.3865
1206.030 5.06549
1208.883 4.77351
1212.571 25.596
1223.501 5.17221
1237.177 9.09947
1239.931 2.82577
1253.500 27.2693
1267.255 14.5401
1283.679 49.9197
1284.293 23.8564
1285.608 10.906
1291.971 30.4317
1294.728 33.0733
1295.937 12.9001
1300.133 10.2702
1301.575 18.4053
1306.613 2.17153
1310.200 3.11254
1311.311 24.108
1312.732 168.43
1313.856 33.8079
1316.720 20.4709
1318.022 18.4121
1330.775 493.177
1332.410 7.62941
1334.919 276.823
1342.553 15.8153
1347.917 49.035
1352.754 10.4218
1365.961 2.38493
1411.993 16.5641
1421.382 5.92849
1422.834 13.2673
1427.870 6.36529
1429.926 79.7694
1431.722 3.76263
1445.801 26.9645
1448.835 27.7466
1463.834 69.1721
1493.066 7.07749
1493.899 56.4114
1519.772 20.5911
1524.692 13.8636
1537.328 6.81056
1537.993 37.1025
1542.927 21.0806
1594.902 14.2769
1612.839 8.7964
1626.993 5.43357
1629.904 7.75357
1639.900 35.0759</textarea>
    <textarea class="span4" name="heavy_scan" rows="12" cols="72">
254.318 12.9435
263.997 10.6159
265.121 10.5421
269.629 2.16
275.195 9.88395
281.582 3.48145
292.053 20.4836
293.248 13.0846
296.142 13.6556
298.270 10.9813
303.356 10.5426
310.156 57.8003
311.435 30.8839
314.150 9.77567
317.261 11.9882
319.226 5.87946
320.283 6.16938
321.392 9.15571
322.291 27.4026
324.157 6.40348
326.124 2.82506
331.647 7.60851
338.304 11.3755
339.489 17.9443
341.085 10.9093
349.246 83.7398
350.277 16.3216
352.223 10.2568
353.409 24.8738
354.377 1.7617
356.029 83.6778
361.400 4.68344
364.744 39.5238
365.370 30.9342
366.274 10.1135
367.094 13.5186
371.212 2.59918
372.345 9.95254
375.233 13.944
378.275 10.0337
379.148 26.3102
383.244 33.1147
384.101 5.98939
388.389 2.15923
390.065 17.8398
392.353 16.7429
393.254 12.6792
397.133 14.6751
398.250 6.47189
399.584 12.2638
404.323 14.1219
409.410 19.0883
410.808 12.091
413.114 15.3433
418.237 3.25488
419.209 4.65355
427.099 21.4184
428.395 3.2595
436.187 11.9642
438.480 3.6968
443.018 1.94978
449.384 2.62226
453.488 25.2399
455.360 16.0947
456.402 7.7413
459.670 34.8144
460.329 41.6677
461.616 4.78827
464.391 99.6922
465.329 11.815
466.211 16.4152
467.338 29.8907
468.358 7.30661
469.488 17.0767
470.890 1.94138
473.159 20.4419
477.033 11.0449
478.233 142.671
479.348 40.6523
480.865 24.7411
482.151 64.0012
483.459 52.9611
484.633 9.5145
487.288 105.601
488.206 26.2281
489.088 29.5177
490.383 8.99893
492.631 2.31928
500.649 5.59757
503.379 4.65053
510.143 18.3302
512.449 13.369
513.352 25.6377
517.606 11.4928
523.358 5.01095
527.422 15.9027
529.245 23.8778
530.421 46.0592
533.196 9.55589
534.222 3.30023
536.446 6.75733
538.706 21.6702
540.320 18.0544
542.470 4.18965
543.356 6.53867
545.728 3.47906
552.850 6.64406
557.303 19.4431
558.307 64.0538
559.329 75.7268
563.554 14.8202
564.437 2.8465
566.752 8.34952
570.546 5.73541
572.710 19.2433
574.676 28.4078
575.516 8.47956
576.324 112.378
577.452 37.7402
578.448 22.5269
579.217 16.5948
580.440 15.4495
581.596 23.6761
583.040 7.8375
584.021 16.4799
585.780 4.00703
588.539 2.16791
589.346 3.04844
591.772 26.573
592.651 32.0312
593.701 110.448
595.068 121.467
595.675 21.8517
596.623 36.7072
600.895 15.7318
601.965 16.6396
602.569 35.0618
603.770 45.585
604.993 42.5616
606.006 3.92297
607.276 25.8079
608.374 33.9642
609.505 4.21705
610.431 15.5119
613.641 16.2131
615.919 7.63088
617.324 28.1823
618.159 9.24852
619.524 11.2427
622.411 21.9765
625.279 9.60316
626.202 6.82656
626.974 19.5453
627.705 31.6369
628.618 2.48484
629.958 7.8423
631.261 5.554
632.347 34.1484
633.635 13.9033
634.605 16.6576
635.432 15.5762
636.206 8.26401
638.444 53.9084
639.547 109.355
641.188 16.8913
641.794 3.0107
642.942 108.762
644.109 95.0058
644.976 17.9351
645.776 6.19141
648.001 29.8798
648.616 9.65154
649.687 56.3038
650.721 5.4132
652.480 74.1429
653.696 15.5988
655.650 11.4768
656.842 75.4473
657.715 71.4869
658.761 148.589
659.439 4.37328
660.186 4.43618
661.555 28.3362
662.529 19.035
663.349 5.45243
664.637 7.50227
665.640 32.0842
666.938 159.449
667.786 84.3514
668.814 34.2774
669.663 11.4347
670.619 5.9597
673.134 16.8795
673.802 4.98271
674.840 27.2788
675.568 19.7375
676.445 24.7577
678.793 2.60269
680.536 25.6987
682.655 15.4133
684.565 135.503
685.929 176.61
686.569 56.4102
687.546 58.7723
688.459 39.3056
689.276 10.1247
690.500 15.2986
691.400 5.65462
692.151 20.3729
693.106 54.0773
693.766 7.24752
694.620 11.3331
695.691 24.4242
696.902 24.9865
697.562 7.20411
699.625 28.6374
700.387 30.3172
701.549 35.7134
704.366 1801.09
705.419 827.51
706.484 403.926
707.484 105.142
708.266 85.3724
709.120 31.3612
709.743 7.91725
710.751 21.7726
713.079 129.784
714.040 33.1092
715.680 40.8693
716.360 47.1441
717.512 170.457
720.607 3.9985
722.447 2.46124
726.110 37.5863
727.188 9.23472
729.450 3.04289
731.134 72.407
732.238 51.575
733.550 74.3763
734.495 99.2573
735.768 10.3342
739.692 194.207
740.661 203.587
743.273 19.6406
744.565 16.7379
745.645 8.50251
747.990 205.745
748.669 937.913
749.585 746.553
750.313 21.9396
751.921 64.384
752.699 57.712
753.714 32.0079
755.327 9.70681
756.866 234.218
757.711 523.022
758.597 556.445
759.271 36.505
760.455 88.6823
761.404 35.8128
762.501 83.0789
763.500 16.5268
764.631 10.3532
767.768 14.9226
770.826 49.9079
771.579 33.0946
773.167 25.7069
774.135 19.8476
776.520 42.751
777.989 33.6573
779.236 55.5017
780.376 99.1686
781.135 31.6343
782.167 7.69504
783.871 60.132
785.015 47.4473
786.088 17.0798
788.334 8.03443
790.541 69.838
791.519 62.1085
792.632 87.2501
793.685 24.6483
794.834 2.60562
796.193 27.2391
796.904 31.4391
798.047 8.13036
798.707 90.0282
799.609 101.022
800.249 104.521
802.532 174.568
803.413 27.1915
804.376 85.9137
807.007 4.13529
808.734 46.6065
810.761 5.22937
812.499 591.189
813.527 693.499
814.232 73.048
814.867 5.74409
817.228 61.8489
818.100 49.256
820.280 71.7917
821.530 1790.83
822.511 2394.96
823.163 35.82
823.793 4.42043
824.622 28.3239
825.812 176.974
826.778 64.5531
827.709 25.0479
830.851 12.8209
832.580 30.7272
834.547 1256.48
835.529 1516.92
836.265 108.067
837.116 4.07129
837.919 41.4228
838.839 13.3998
840.080 17.9543
840.776 61.5063
843.402 2111.8
844.475 2404.64
845.097 8.98864
845.902 42.6862
847.464 15.6826
848.258 74.2998
849.931 10.2287
850.570 14.9991
851.282 21.259
853.453 44.715
854.334 26.633
854.958 59.093
855.625 48.852
857.219 68.8694
858.418 51.1018
859.379 7.47303
860.388 11.2911
861.206 9.0099
864.801 12.7303
866.668 29.2172
868.015 17.3187
868.801 9.87445
872.608 18.0914
873.581 7.64138
875.845 36.0815
876.849 45.216
877.710 49.6969
878.399 19.3319
881.636 2.60254
882.410 11.3555
883.626 63.462
884.394 52.9086
885.826 232.724
886.884 162.685
888.096 33.078
889.676 550.746
890.502 612.116
891.372 77.5893
893.882 2.66775
896.654 11.2371
898.575 2555.68
899.512 2225.36
900.198 51.0163
901.225 35.8197
902.637 5.98684
913.988 3.91031
914.592 3.16827
919.817 33.3525
920.652 30.8755
921.472 9.43983
923.241 13.2541
925.350 15.6841
925.985 3.41217
928.630 24.7865
930.819 20.9231
931.660 24.6431
932.827 4.12994
934.967 11.7242
935.656 30.2756
936.684 52.5297
937.758 29.9113
938.644 16.1601
940.742 92.1308
943.863 36.1496
945.841 4.29229
947.818 10.5982
949.121 42.9285
949.815 28.8822
953.528 2.60607
956.940 7.02729
960.685 52.7138
961.759 4.92647
962.685 60.2774
964.016 17.905
964.708 31.6552
966.277 43.8463
966.918 54.2685
967.653 54.2176
968.525 9.31581
969.739 11.6957
970.714 4.19994
974.738 12.5779
976.678 9.56247
980.857 38.0528
981.797 19.1826
982.514 51.1714
983.360 10.8912
984.720 39.4099
986.440 22.5768
987.647 16.2172
989.750 4.90215
991.801 2.60375
994.890 19.3996
995.638 2.59545
996.797 34.0436
997.892 14.8807
1000.883 2.38044
1007.701 15.449
1008.622 17.3406
1010.718 17.9977
1012.762 64.3855
1020.466 11.6196
1021.186 4.67814
1032.055 2.3924
1036.299 2.06999
1037.619 6.31733
1040.643 4.31145
1042.049 5.95981
1042.742 60.1434
1047.950 13.0031
1051.261 31.9186
1054.081 6.41496
1056.367 32.638
1057.479 50.7998
1058.566 4.65362
1059.699 91.3677
1060.677 57.6313
1065.381 11.0025
1068.205 30.5848
1068.921 23.6245
1073.743 226.734
1074.658 329.026
1075.799 350.708
1076.973 216.2
1077.796 646.758
1078.778 26.8017
1081.316 40.6242
1086.730 8.06574
1090.586 32.7604
1091.679 49.5937
1092.811 80.1216
1093.863 98.249
1094.776 283.699
1095.820 86.1252
1099.715 12.9269
1105.858 15.6344
1107.612 3.48314
1108.852 92.4506
1109.713 91.7749
1110.632 212.876
1111.680 24.0865
1112.778 332.502
1116.740 25.0162
1117.462 27.8395
1118.128 7.47939
1121.460 19.3455
1127.557 17.0869
1131.187 2.90107
1135.449 1.95256
1139.567 22.3366
1140.603 19.3461
1141.589 45.2588
1142.488 6.83859
1143.765 15.7935
1148.367 13.5558
1151.859 15.7953
1158.402 19.3261
1160.034 4.57655
1161.062 13.9052
1164.144 25.8672
1164.813 5.27122
1166.096 23.3709
1166.900 58.6024
1167.656 14.5201
1168.567 30.5423
1169.640 4.30332
1170.783 20.7344
1179.082 8.95191
1181.711 25.1077
1183.863 35.342
1184.992 77.6401
1185.925 75.2258
1186.842 124.524
1188.406 176.998
1189.199 36.7613
1189.905 8.48225
1190.652 15.266
1193.022 23.0081
1193.721 5.03257
1198.679 10.8258
1199.796 11.6136
1203.343 18.3589
1204.708 45.3393
1205.954 55.7715
1206.677 82.5377
1209.479 7.18528
1214.437 4.86486
1215.114 3.99414
1216.903 29.6978
1222.058 15.8187
1223.813 2.29764
1228.708 12.7245
1229.670 4.13823
1237.053 6.7969
1252.627 18.0034
1260.098 6.98014
1267.893 18.8976
1269.860 22.9993
1274.854 25.8566
1276.602 16.2347
1278.902 23.6896
1280.448 24.2863
1283.488 16.1874
1284.907 39.76
1285.763 38.7232
1286.920 2.1703
1287.859 88.2074
1292.761 16.1036
1295.967 76.478
1297.074 10.6879
1298.633 27.8163
1299.341 5.63321
1300.167 16.0777
1301.486 3.56451
1303.873 34.3453
1305.809 59.7537
1311.917 26.4167
1313.664 39.761
1314.908 147.123
1315.857 56.8366
1316.837 210.081
1317.909 4.28774
1318.785 17.9495
1319.692 7.28221
1320.525 32.728
1321.209 14.5715
1321.980 34.6806
1326.372 5.52165
1330.809 61.0789
1331.929 120.952
1332.937 269.168
1334.261 271.356
1334.937 471.845
1335.869 24.6294
1336.765 107.476
1338.124 109.227
1338.815 184.438
1339.620 5.08941
1350.045 6.02866
1351.225 3.25837
1367.638 19.0247
1371.944 3.69652
1396.807 4.3505
1401.028 29.9716
1405.773 15.2932
1406.840 9.34991
1409.021 11.6979
1410.394 12.113
1412.528 20.9549
1413.842 6.28494
1415.134 25.897
1415.820 17.4702
1416.598 1.29574
1424.102 9.31613
1425.072 23.3865
1430.678 34.5611
1431.805 58.73
1432.886 61.71
1433.951 100.675
1448.922 16.4877
1450.039 9.27174
1450.874 12.0768
1452.722 31.839
1453.426 1.31083
1464.503 69.3152
1465.880 72.8237
1466.802 55.6129
1468.023 112.195
1469.056 3.25838
1471.073 16.6602
1479.728 6.45821
1497.750 12.3247
1521.737 11.3975
1522.586 6.21657
1524.109 47.1638
1526.340 10.4022
1529.219 8.78328
1540.026 20.1776
1541.486 7.94665
1544.073 9.88974
1544.978 8.05259
1546.658 18.9772
1559.963 10.3075
1565.809 7.71877
1583.888 3.59322
1598.929 29.5558
1607.292 6.81875
1623.799 6.1667
1626.245 7.87457
1652.105 1.95278
1669.912 70.8671
1717.705 4.57016
1761.283 9.45868
1765.347 13.6168
1778.694 5.74963</textarea>
  
</div>
</div>
<div class="row"
<div class="span8">
<center><input class="btn btn-primary" type="submit" value="Perform Xlink" /></center> 
</div>
</div>
</fieldset> 
</form> 
</div> 
</div> 

ENDHTML

$dbh->disconnect();

print_page_bottom_bootstrap;
exit;
